@extends('layouts.app')

@section('title', 'About Us')

@section('content')
<div class="container py-5">
    <div class="row">
        <div class="col-lg-8 mx-auto">
            <h1 class="mb-4">About VapeBay</h1>
            
            <p class="lead">Your trusted partner in the world of premium vaping products.</p>
            
            <img src="/api/placeholder/800/400" alt="About VapeBay" class="img-fluid rounded mb-4">
            
            <h2>Our Story</h2>
            <p>Founded in 2023, VapeBay started with a simple mission: to provide high-quality vaping products with exceptional customer service. What began as a small online store has grown into a trusted name in the vaping community.</p>
            
            <p>Our team consists of passionate vapers who understand the importance of quality, safety, and variety in vaping products. We carefully select each item in our inventory to ensure it meets our high standards.</p>
            
            <h2>Our Mission</h2>
            <p>At VapeBay, our mission is to offer a premium selection of vaping products that enhance the vaping experience for both beginners and experienced enthusiasts. We strive to:</p>
            
            <ul>
                <li>Source the highest quality products from reputable manufacturers</li>
                <li>Provide exceptional customer service and support</li>
                <li>Educate our customers about safe and responsible vaping practices</li>
                <li>Offer competitive pricing without compromising on quality</li>
                <li>Stay at the forefront of vaping technology and trends</li>
            </ul>
            
            <h2>Our Team</h2>
            <p>Behind VapeBay is a dedicated team of vaping enthusiasts who are passionate about what they do. Our team includes:</p>
            
            <div class="row mt-4">
                <div class="col-md-4 mb-4">
                    <div class="card h-100">
                        <img src="/api/placeholder/300/300" class="card-img-top" alt="Team Member">
                        <div class="card-body">
                            <h5 class="card-title">John Smith</h5>
                            <p class="card-text">Founder & CEO</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card h-100">
                        <img src="/api/placeholder/300/300" class="card-img-top" alt="Team Member">
                        <div class="card-body">
                            <h5 class="card-title">Jane Doe</h5>
                            <p class="card-text">Product Specialist</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="card h-100">
                        <img src="/api/placeholder/300/300" class="card-img-top" alt="Team Member">
                        <div class="card-body">
                            <h5 class="card-title">Mike Johnson</h5>
                            <p class="card-text">Customer Support Lead</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <h2>Our Values</h2>
            <p>Everything we do at VapeBay is guided by our core values:</p>
            
            <div class="row mt-4">
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title">Quality</h5>
                            <p class="card-text">We never compromise on the quality of our products.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title">Integrity</h5>
                            <p class="card-text">We operate with honesty and transparency in all we do.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title">Customer Focus</h5>
                            <p class="card-text">Our customers' satisfaction is our top priority.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 mb-4">
                    <div class="card h-100">
                        <div class="card-body">
                            <h5 class="card-title">Responsibility</h5>
                            <p class="card-text">We promote responsible vaping practices and compliance with regulations.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection